﻿using System;
using System.Collections;
using System.Drawing;
using System.Windows.Forms;
using Psion.RFID.HF;
using Psion.RFID.PlugIns;

namespace HF_Demo
{
    public sealed partial class PlugInsForm : Form
    {
        private readonly Reader _reader;
        private ArrayList _plugIns;

        public PlugInsForm(Reader reader)
        {
            InitializeComponent();

            Height = Screen.PrimaryScreen.WorkingArea.Height;

            _plugIns = new ArrayList();
            _reader = reader;
        }

        /// <summary>
        /// Loads the plugins detected in /PlugIns folder.
        /// </summary>
        private void LoadPlugins()
        {
            try
            {
                try
                {
                    // Load modules

                    _plugIns = PlugInManager.Instance.Get(typeof (PlugIn));

                    if (_plugIns != null)
                    {
                        foreach (PlugIn plugin in _plugIns)
                        {
                            var lvi = new ListViewItem(new[] {plugin.Key, plugin.Version});
                            lv_plugIns.Items.Add(lvi);
                        }

                        _lbPlugIns.ForeColor = Color.Green;
                        _lbPlugIns.Text = "Plug-ins loaded";
                    }

                    else
                    {
                        _lbPlugIns.ForeColor = Color.Orange;
                        _lbPlugIns.Text = "No Plug-ins found";
                    }
                }

                catch (Exception)
                {
                    _lbPlugIns.ForeColor = Color.Red;
                    _lbPlugIns.Text = "Error in Plug-ins loading";
                }
            }

            catch (Exception ex)
            {
                _lbPlugIns.Text = ex.Message;
            }
        }

        /// <summary>
        /// Handles the Click event of the menuItem1 control.
        /// </summary>
        /// <param name="sender">The source of the event.</param>
        /// <param name="e">The <see cref="System.EventArgs"/> instance containing the event data.</param>
        private void MenuItem1Click(object sender, EventArgs e)
        {
            Close();
        }


        /// <summary>
        /// Handles the Load event of the PlugIns_Form control.
        /// </summary>
        /// <param name="sender">The source of the event.</param>
        /// <param name="e">The <see cref="System.EventArgs"/> instance containing the event data.</param>
        private void PlugInsFormLoad(object sender, EventArgs e)
        {
            LoadPlugins();
        }

        /// <summary>
        /// Handles the 1 event of the bt_Launch_Click control.
        /// </summary>
        /// <param name="sender">The source of the event.</param>
        /// <param name="e">The <see cref="System.EventArgs"/> instance containing the event data.</param>
        private void BtLaunchClick1(object sender, EventArgs e)
        {
            try
            {
                if (lv_plugIns.SelectedIndices.Count == 1)
                {
                    _lbPlugIns.ForeColor = Color.Black;
                    _lbPlugIns.Text = "Executing...";
                    _lbPlugIns.Refresh();

                    if (_plugIns != null)
                    {
                        string key = lv_plugIns.Items[lv_plugIns.SelectedIndices[0]].SubItems[0].Text;

                        PlugIn module = PlugInManager.Instance.Get(
                            typeof (PlugIn),
                            key);


                        // execute the reader according to the rfid driver installed

                        //bool r = ExecutePlugIn(module);
                        try
                        {
                            module.Execute(_reader);
                            _lbPlugIns.ForeColor = Color.Green;

                            _lbPlugIns.Text = "Execution succeeded";
                        }
                        catch (Exception)
                        {
                            _lbPlugIns.ForeColor = Color.Red;
                        }


                        _lbPlugIns.Refresh();
                    }
                }
            }

            catch (Exception ex)
            {
                MessageBox.Show(ex.Message, "ERROR");
            }
        }
    }
}